;;; Add a new directory to Emacs' load path.
;;;
(setq load-path (cons (expand-file-name "~/lib/emacs/lisp") load-path))

;;; Fax configuration.
;;;
(autoload 'fax "sendfax"
  "Edit a fax message to be sent via a Mail-to-Fax gateway." t)

(setq sendfax-program "/opt/bin/faxpr"
      sendfax-switches '("-t" "mail" "-x"))

(add-hook 'fax-mode-hook
	  (function (lambda ()
		      (setq fill-column 76))))

(setq fax-default-headers
      (concat "X-Fax-From:+ +49-7352-7425\n"
	      "X-Fax-From-Phone: ++49-7352-51322\n"
	      "X-Fax-From-Name: Ralph Schleicher\n"
	      "X-Fax-From-Location: 88416 Ochsenhausen\n"
	      "X-Fax-Date: |date +\"Ochsenhausen, %d. %B %Y\"\n"
	      "X-Fax-To: \n"
	      "X-Fax-To-Organization: \n"
	      "X-Fax-To-Department: \n"
	      "X-Fax-To-Name: \n"
	      "X-Fax-To-Location: \n"
	      "X-Fax-Closing: Tsch\n"
	      "X-Fax-Signature: /home/rs/lib/tex/graphics/ralph.ps\n"))
