## libfax.pl -- this file is part of FAXpr.
##
## Copyright (C) 1995 Ralph Schleicher
##
## This program is free software; you can redistribute it and/or
## modify it under the terms of the GNU General Public License as
## published by the Free Software Foundation; either version 2 of
## the License, or (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


die "libfax.pl: Undefined variable `\$fax_dir'\n"
  unless defined ($fax_dir);

$config_file = "${fax_dir}/config";
$resource_file = "$ENV{'HOME'}/.faxrc";


package FAX;

$driver{'normal'} = '-sDEVICE=dfaxlow';
$driver{'fine'} = '-sDEVICE=dfaxhigh';


sub main'configure
{
  local (*CONF, $config, $name, $number);

  foreach $config (@_)
    {
      open (CONF, $config)
	|| die "$0:$config: $!\n";

      foreach (<CONF>)
	{
	  s/^\s+//;

	  next if /^#/;
	  next if /^$/;

	  chop;

	  push (@config, $_);

	  if (/^alias\s+(\S+)\s+(.+)/)
	    {
	      $name = $1;
	      $number = $2;

	      if ($number =~ /^\|/)
		{
		  $number =~ s/^\|//;
		  $number = `$number`;

		  chop $number;

		  die "$0:$config:$.: Alias evaluates to null\n"
		    if $number =~ /^\s*$/;
		}

	      $alias{$name} = $number;
	    }
	  elsif (/^dialtrans\s+(.+)/)
	    {
	      push (@dialtrans, $1);
	    }
	  elsif (/^command\s+(\S+)\s+(.+)/)
	    {
	      $command{$1} = $2;
	    }
	  elsif (/^driver\s+normal\s+(.+)/)
	    {
	      $driver{'normal'} = join ('=', '-sDEVICE', $1);
	    }
	  elsif (/^driver\s+fine\s+(.+)/)
	    {
	      $driver{'fine'} = join ('=', '-sDEVICE', $1);
	    }
	  elsif (/^sendfax\s+(.+)/)
	    {
	      $sendfax = $1;
	    }
	  elsif (/^viewfax\s+(.+)/)
	    {
	      $viewfax = $1;
	    }
	  elsif (/^printfax\s+(.+)/)
	    {
	      $printfax = $1;
	    }
	  elsif (/^server\s+(\S+)\s*$/)
	    {
	      push (@server, $1);
	    }
	  else
	    {
	      die "$0:$config:$.: Parse error\n";
	    }
	}

      close (CONF);
    }
}


sub main'getconfig
{
  local (@these) = ();

  return @config
    if @_ == 0;

  foreach $key (@_)
    {
      push (@these, grep (/^$key\s+/, @config));
    }

  return @these
    if wantarray;

  pop @these;
}


sub main'resolve
{
  local (@work, %done, $num, $rule, @number);

  for (@work = @_; @work > 0; ++$done{shift @work})
    {
      unshift (@work, split (/\s*,\s*/, $alias{shift @work}))
	while $alias{$work[0]} ne '';
    }

  foreach $num (keys %done)
    {
      foreach $rule (@dialtrans)
	{
	  eval "\$num =~ s$rule";
	  die "$0: $@\n"
	    if $@ ne '';
	}

      push (@number, $num);
    }

  return @number
    if wantarray;

  $number[0];
}


sub main'gsdevice
{
  $driver{$_[0]};
}


sub main'command
{
  local ($key, @arg) = @_;

  $command{$key} = $key
    if $command{$key} eq '';

  system ("$command{$key} @arg");
}


1;


## libfax.pl ends here
