## getopt.pl -- parsing command line arguments.
##
## Copyright (C) 1994--1997 Ralph Schleicher
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
## 
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
## 
## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING.  If not, write to
## the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
## Boston, MA 02111-1307, USA.
##
##
## Usage:
##
## &getopt ('f:flag:0:$f_opt = 1'
##	    'a:with-arg:1:$a_opt = $optarg',
##	    '?:help:0:&usage, exit 0');


$optopt = '';
$optarg = '';


sub getopt
{
  local (@save, $opt,
    $short, $long, $arg, $action,
      @short, @long, @arg, @action);

  for ($opt = 0; $_ = @_[$opt]; ++$opt)
    {
      ($short, $long, $arg, $action) = split (':', $_, 4);

      next if !($short ne '' || $long ne '') || ($arg =~ /\D/);

      if ($action eq '')
	{
	  $action .= "\$opt-$short = "
	    if $short ne '';
	  $action .= "\$$long = "
	    if $long ne '';
	  $action .= "\$optarg";

	  $action =~ s/-/_/g;
	}

      $short[$opt] = "-$short";
      $long[$opt] = "--$long";
      $arg[$opt] = $arg;
      $action[$opt] = $action;
    }

  while (@ARGV > 0)
    {
      $_ = shift @ARGV;

      push (@save, $_), next if ! /^-/;
      push (@save, @ARGV), last if /^--?$/;

      for ($opt = 0; $opt < @action; ++$opt)
	{
	  last if $short[$opt] && ($_ eq $short[$opt]);
	  last if $long[$opt] && ($_ eq $long[$opt]);
	}

      die "$0: Unknown option `$_'\n"
	if $opt > $#action;

      $optopt = $opt;
      $optarg = $arg[$opt] ? shift @ARGV : 1;

      die "$0: Missing option argument for `$_'\n"
	if $optarg eq '';

      eval $action[$optopt];

      die "$0:getopt: $@\n"
	if $@ ne '';
    }

  @ARGV = @save;
}


1;


## getopt.pl ends here
