/* c-errno.h --- error handling.

   Copyright (C) 2002 Ralph Schleicher

   Author: Ralph Schleicher <rs@nunatak.allgaeu.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
   Boston, MA 02111-1307, USA.  */


#ifndef IAPWS_C_ERRNO_H
#define IAPWS_C_ERRNO_H


#include <errno.h>

/* Global 'errno' variable.  */
extern int errno;

/* Set the 'errno' variable to error code E.  */
#ifndef __set_errno
#define __set_errno(e) errno = (e)
#endif

/* Set the 'errno' variable to error code E.  */
#define set_errno(e)							\
do									\
  {									\
    __set_errno (e);							\
  }									\
while (0)

/* Set the 'errno' variable to error code E
   and return VALUE back to the caller.  */
#define set_errno_and_return(e,value)					\
do									\
  {									\
    __set_errno (e);							\
    return value;							\
  }									\
while (0)

/* Set the 'errno' variable to error code E
   and go to LABEL.  */
#define set_errno_and_goto(e,label)					\
do									\
  {									\
    __set_errno (e);							\
    goto label;								\
  }									\
while (0)


#endif /* not IAPWS_C_ERRNO_H */
