/* c-math.h --- mathematics.

   Copyright (C) 2002 Ralph Schleicher

   Author: Ralph Schleicher <rs@nunatak.allgaeu.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
   Boston, MA 02111-1307, USA.  */


#ifndef IAPWS_C_MATH_H
#define IAPWS_C_MATH_H


#include <float.h>
#include <math.h>

/* Return two times X.  */
#define sq(x) (x) * (x)

/* Evaluate the expression 'product *= pow (base, exponent)'.

   The arguments BASE and EXPONENT should have no side effects; that
   means it must be save to evaluate them more than once.  */
#define prod(product,base,exponent)					\
do									\
  {									\
    double __base = (base);						\
    double __exp = (exponent);						\
									\
    if (__base == 0.0)							\
      product = 0.0;							\
    else if (__base != 1.0)						\
      {									\
	if (__exp == 1.0)						\
	  product *= __base;						\
	else if (__exp == -1.0)						\
	  product /= __base;						\
	else if (__exp != 0.0)						\
	  product *= pow (__base, __exp);				\
      }									\
  }									\
while (0)


#endif /* not IAPWS_C_MATH_H */
