/* b2bc.c --- boundary line between subregions 2b and 2c.

   Copyright (C) 2001, 2002 Ralph Schleicher

   Author: Ralph Schleicher <rs@nunatak.allgaeu.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
   Boston, MA 02111-1307, USA.  */


#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <c-stand.h>
#include <c-errno.h>
#include <c-math.h>

#include "if97.h"
#include "if97i.h"
#include "local.h"


/* Table 3.19: Coefficients of equations (3.13) and (3.14).  */
struct t319
  {
    /* Index.  */
    int i;

    /* Coefficient.  */
    double n;
  };

static const struct t319 t319[] =
  {
    {1,  0.90584278514723E+03},
    {2, -0.67955786399241E+00},
    {3,  0.12809002730136E-03},
    {4,  0.26526571908428E+04},
    {5,  0.45257578905948E+01},
  };

#define n(i) t319[i].n

/* Reference pressure.  */
#define p_star 1.0E+6

/* Reference enthalpy.  */
#define h_star 1.0E+3


/* Return the boundary pressure corresponding to the boundary
   enthalpy H.  */
double
if97i_p_b2bc (double h)
{
  return (n(0) + h / h_star * (n(1) + h / h_star * n(2))) * p_star;
}


/* Return the boundary enthalpy corresponding to the boundary
   pressure P.  */
double
if97i_h_b2bc (double p)
{
  return (n(3) + sqrt ((p / p_star - n(4)) / n(2))) * h_star;
}
