/* if97.c --- IF97 data structure.

   Copyright (C) 2001, 2002 Ralph Schleicher

   Author: Ralph Schleicher <rs@nunatak.allgaeu.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
   Boston, MA 02111-1307, USA.  */


#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <c-stand.h>

#include "if97.h"


/* Allocate an array of IF97 data structures with N elements.

   Return value is the address of the array.  In case of an error, the
   'if97_create' function sets 'errno' and returns a null pointer.  */
struct if97 *
if97_create (size_t n)
{
  struct if97 *mem, *prop;

  mem = calloc (n, sizeof (struct if97));
  if (mem != NULL)
    {
      for (prop = mem; n > 0; --n)
	{
	  prop->if_p = 0.0;
	  prop->if_t = 0.0;
	  prop->if_v = 0.0;
	  prop->if_h = 0.0;
	  prop->if_u = 0.0;
	  prop->if_s = 0.0;
	  prop->if_cp = 0.0;
	  prop->if_cv = 0.0;
	  prop->if_w = 0.0;

	  ++prop;
	}
    }

  return mem;
}


/* Free the array of IF97 data structures pointed at by MEM.
   It is no error if MEM is a null pointer.

   Return value is always a null pointer.  */
struct if97 *
if97_destroy (struct if97 *mem)
{
  if (mem != NULL)
    free (mem);

  return NULL;
}
