/* if97i.h --- IAPWS-IF97 internal interface.

   Copyright (C) 2001, 2002 Ralph Schleicher

   Author: Ralph Schleicher <rs@nunatak.allgaeu.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
   Boston, MA 02111-1307, USA.  */


#ifndef IAPWS_IF97I_H
#define IAPWS_IF97I_H


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Equations for region 1.
 */

/* Basic equation (temperature interface).  */
extern double if97i_t1_p_star (void) __attribute__ ((const));
extern double if97i_t1_t_star (void) __attribute__ ((const));

extern double if97i_t1_pi (double __p) __attribute__ ((const));
extern double if97i_t1_tau (double __t) __attribute__ ((const));
extern double if97i_t1_gamma (double __pi, double __tau) __attribute__ ((const));
extern double if97i_t1_gamma_pi (double __pi, double __tau) __attribute__ ((const));
extern double if97i_t1_gamma_tau (double __pi, double __tau) __attribute__ ((const));
extern double if97i_t1_gamma_pi_pi (double __pi, double __tau) __attribute__ ((const));
extern double if97i_t1_gamma_tau_tau (double __pi, double __tau) __attribute__ ((const));
extern double if97i_t1_gamma_pi_tau (double __pi, double __tau) __attribute__ ((const));

extern struct if97 *if97i_t1 (struct if97 *__prop, double __p, double __t);

extern double if97i_t1_v (double __p, double __t) __attribute__ ((const));
extern double if97i_t1_h (double __p, double __t) __attribute__ ((const));
extern double if97i_t1_u (double __p, double __t) __attribute__ ((const));
extern double if97i_t1_s (double __p, double __t) __attribute__ ((const));
extern double if97i_t1_cp (double __p, double __t) __attribute__ ((const));
extern double if97i_t1_cv (double __p, double __t) __attribute__ ((const));
extern double if97i_t1_w (double __p, double __t) __attribute__ ((const));

/* Backward equation (enthalpy interface).  */
extern double if97i_h1_p_star (void) __attribute__ ((const));
extern double if97i_h1_h_star (void) __attribute__ ((const));
extern double if97i_h1_t_star (void) __attribute__ ((const));

extern double if97i_h1_pi (double __p) __attribute__ ((const));
extern double if97i_h1_eta (double __h) __attribute__ ((const));
extern double if97i_h1_theta (double __pi, double __eta) __attribute__ ((const));

extern double if97i_h1_t (double __p, double __h) __attribute__ ((const));

/* Backward equation (entropy interface).  */
extern double if97i_s1_p_star (void) __attribute__ ((const));
extern double if97i_s1_s_star (void) __attribute__ ((const));
extern double if97i_s1_t_star (void) __attribute__ ((const));

extern double if97i_s1_pi (double __p) __attribute__ ((const));
extern double if97i_s1_sigma (double __s) __attribute__ ((const));
extern double if97i_s1_theta (double __pi, double __sigma) __attribute__ ((const));

extern double if97i_s1_t (double __p, double __s) __attribute__ ((const));

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Equations for region 2.
 */

/* Basic equation (temperature interface).  */
extern double if97i_t2_p_star (void) __attribute__ ((const));
extern double if97i_t2_t_star (void) __attribute__ ((const));

extern double if97i_t2_pi (double __p) __attribute__ ((const));
extern double if97i_t2_tau (double __t) __attribute__ ((const));
extern double if97i_t2_gamma_0 (double __pi, double __tau) __attribute__ ((const));
extern double if97i_t2_gamma_0_pi (double __pi, double __tau) __attribute__ ((const));
extern double if97i_t2_gamma_0_tau (double __pi, double __tau) __attribute__ ((const));
extern double if97i_t2_gamma_0_pi_pi (double __pi, double __tau) __attribute__ ((const));
extern double if97i_t2_gamma_0_tau_tau (double __pi, double __tau) __attribute__ ((const));
extern double if97i_t2_gamma_0_pi_tau (double __pi, double __tau) __attribute__ ((const));
extern double if97i_t2_gamma_r (double __pi, double __tau) __attribute__ ((const));
extern double if97i_t2_gamma_r_pi (double __pi, double __tau) __attribute__ ((const));
extern double if97i_t2_gamma_r_tau (double __pi, double __tau) __attribute__ ((const));
extern double if97i_t2_gamma_r_pi_pi (double __pi, double __tau) __attribute__ ((const));
extern double if97i_t2_gamma_r_tau_tau (double __pi, double __tau) __attribute__ ((const));
extern double if97i_t2_gamma_r_pi_tau (double __pi, double __tau) __attribute__ ((const));

extern struct if97 *if97i_t2 (struct if97 *__prop, double __p, double __t);

extern double if97i_t2_v (double __p, double __t) __attribute__ ((const));
extern double if97i_t2_h (double __p, double __t) __attribute__ ((const));
extern double if97i_t2_u (double __p, double __t) __attribute__ ((const));
extern double if97i_t2_s (double __p, double __t) __attribute__ ((const));
extern double if97i_t2_cp (double __p, double __t) __attribute__ ((const));
extern double if97i_t2_cv (double __p, double __t) __attribute__ ((const));
extern double if97i_t2_w (double __p, double __t) __attribute__ ((const));

/* Backward equation (enthalpy interface).  */
extern double if97i_h2_t (double __p, double __h) __attribute__ ((const));

/* Subregion 2a.  */
extern double if97i_h2a_p_star (void) __attribute__ ((const));
extern double if97i_h2a_h_star (void) __attribute__ ((const));
extern double if97i_h2a_t_star (void) __attribute__ ((const));

extern double if97i_h2a_pi (double __p) __attribute__ ((const));
extern double if97i_h2a_eta (double __h) __attribute__ ((const));
extern double if97i_h2a_theta (double __pi, double __eta) __attribute__ ((const));

extern double if97i_h2a_t (double __p, double __h) __attribute__ ((const));

/* Subregion 2b.  */
extern double if97i_h2b_p_star (void) __attribute__ ((const));
extern double if97i_h2b_h_star (void) __attribute__ ((const));
extern double if97i_h2b_t_star (void) __attribute__ ((const));

extern double if97i_h2b_pi (double __p) __attribute__ ((const));
extern double if97i_h2b_eta (double __h) __attribute__ ((const));
extern double if97i_h2b_theta (double __pi, double __eta) __attribute__ ((const));

extern double if97i_h2b_t (double __p, double __h) __attribute__ ((const));

/* Subregion 2c.  */
extern double if97i_h2c_p_star (void) __attribute__ ((const));
extern double if97i_h2c_h_star (void) __attribute__ ((const));
extern double if97i_h2c_t_star (void) __attribute__ ((const));

extern double if97i_h2c_pi (double __p) __attribute__ ((const));
extern double if97i_h2c_eta (double __h) __attribute__ ((const));
extern double if97i_h2c_theta (double __pi, double __eta) __attribute__ ((const));

extern double if97i_h2c_t (double __p, double __h) __attribute__ ((const));

/* Backward equation (entropy interface).  */
extern double if97i_s2_t (double __p, double __s) __attribute__ ((const));

/* Subregion 2a.  */
extern double if97i_s2a_p_star (void) __attribute__ ((const));
extern double if97i_s2a_s_star (void) __attribute__ ((const));
extern double if97i_s2a_t_star (void) __attribute__ ((const));

extern double if97i_s2a_pi (double __p) __attribute__ ((const));
extern double if97i_s2a_sigma (double __s) __attribute__ ((const));
extern double if97i_s2a_theta (double __pi, double __sigma) __attribute__ ((const));

extern double if97i_s2a_t (double __p, double __s) __attribute__ ((const));

/* Subregion 2b.  */
extern double if97i_s2b_p_star (void) __attribute__ ((const));
extern double if97i_s2b_s_star (void) __attribute__ ((const));
extern double if97i_s2b_t_star (void) __attribute__ ((const));

extern double if97i_s2b_pi (double __p) __attribute__ ((const));
extern double if97i_s2b_sigma (double __s) __attribute__ ((const));
extern double if97i_s2b_theta (double __pi, double __sigma) __attribute__ ((const));

extern double if97i_s2b_t (double __p, double __s) __attribute__ ((const));

/* Subregion 2c.  */
extern double if97i_s2c_p_star (void) __attribute__ ((const));
extern double if97i_s2c_s_star (void) __attribute__ ((const));
extern double if97i_s2c_t_star (void) __attribute__ ((const));

extern double if97i_s2c_pi (double __p) __attribute__ ((const));
extern double if97i_s2c_sigma (double __s) __attribute__ ((const));
extern double if97i_s2c_theta (double __pi, double __sigma) __attribute__ ((const));

extern double if97i_s2c_t (double __p, double __s) __attribute__ ((const));

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Equations for region 3.
 */

/* Basic equation (temperature interface).  */
extern double if97i_t3_rho_star (void) __attribute__ ((const));
extern double if97i_t3_t_star (void) __attribute__ ((const));

extern double if97i_t3_delta (double __rho) __attribute__ ((const));
extern double if97i_t3_tau (double __t) __attribute__ ((const));
extern double if97i_t3_phi (double __delta, double __tau) __attribute__ ((const));
extern double if97i_t3_phi_delta (double __delta, double __tau) __attribute__ ((const));
extern double if97i_t3_phi_tau (double __delta, double __tau) __attribute__ ((const));
extern double if97i_t3_phi_delta_delta (double __delta, double __tau) __attribute__ ((const));
extern double if97i_t3_phi_tau_tau (double __delta, double __tau) __attribute__ ((const));
extern double if97i_t3_phi_delta_tau (double __delta, double __tau) __attribute__ ((const));

extern struct if97 *if97i_t3 (struct if97 *__prop, double __rho, double __t);

extern double if97i_t3_p (double __rho, double __t) __attribute__ ((const));
extern double if97i_t3_v (double __rho, double __t) __attribute__ ((const));
extern double if97i_t3_h (double __rho, double __t) __attribute__ ((const));
extern double if97i_t3_u (double __rho, double __t) __attribute__ ((const));
extern double if97i_t3_s (double __rho, double __t) __attribute__ ((const));
extern double if97i_t3_cp (double __rho, double __t) __attribute__ ((const));
extern double if97i_t3_cv (double __rho, double __t) __attribute__ ((const));
extern double if97i_t3_w (double __rho, double __t) __attribute__ ((const));

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Equations for region 4.
 */

/* Basic equation.  */
extern double if97i_p_s (double __t) __attribute__ ((const));

/* Backward equation.  */
extern double if97i_t_s (double __p) __attribute__ ((const));

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Equations for region 5.
 */

/* Basic equation.  */
extern double if97i_t5_p_star (void) __attribute__ ((const));
extern double if97i_t5_t_star (void) __attribute__ ((const));

extern double if97i_t5_pi (double __p) __attribute__ ((const));
extern double if97i_t5_tau (double __t) __attribute__ ((const));
extern double if97i_t5_gamma_0 (double __pi, double __tau) __attribute__ ((const));
extern double if97i_t5_gamma_0_pi (double __pi, double __tau) __attribute__ ((const));
extern double if97i_t5_gamma_0_tau (double __pi, double __tau) __attribute__ ((const));
extern double if97i_t5_gamma_0_pi_pi (double __pi, double __tau) __attribute__ ((const));
extern double if97i_t5_gamma_0_tau_tau (double __pi, double __tau) __attribute__ ((const));
extern double if97i_t5_gamma_0_pi_tau (double __pi, double __tau) __attribute__ ((const));
extern double if97i_t5_gamma_r (double __pi, double __tau) __attribute__ ((const));
extern double if97i_t5_gamma_r_pi (double __pi, double __tau) __attribute__ ((const));
extern double if97i_t5_gamma_r_tau (double __pi, double __tau) __attribute__ ((const));
extern double if97i_t5_gamma_r_pi_pi (double __pi, double __tau) __attribute__ ((const));
extern double if97i_t5_gamma_r_tau_tau (double __pi, double __tau) __attribute__ ((const));
extern double if97i_t5_gamma_r_pi_tau (double __pi, double __tau) __attribute__ ((const));

extern struct if97 *if97i_t5 (struct if97 *__prop, double __p, double __t);

extern double if97i_t5_v (double __p, double __t) __attribute__ ((const));
extern double if97i_t5_h (double __p, double __t) __attribute__ ((const));
extern double if97i_t5_u (double __p, double __t) __attribute__ ((const));
extern double if97i_t5_s (double __p, double __t) __attribute__ ((const));
extern double if97i_t5_cp (double __p, double __t) __attribute__ ((const));
extern double if97i_t5_cv (double __p, double __t) __attribute__ ((const));
extern double if97i_t5_w (double __p, double __t) __attribute__ ((const));

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Utility equations.
 */

/* Boundary between regions 2 and 3.  */
extern double if97i_p_b23 (double __t) __attribute__ ((const));
extern double if97i_t_b23 (double __p) __attribute__ ((const));

/* Boundary between subregions 2b and 2c.  */
extern double if97i_p_b2bc (double __h) __attribute__ ((const));
extern double if97i_h_b2bc (double __p) __attribute__ ((const));


#endif /* not IAPWS_IF97I_H */
