/* local.h --- local declarations.

   Copyright (C) 2001, 2002 Ralph Schleicher

   Author: Ralph Schleicher <rs@nunatak.allgaeu.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
   Boston, MA 02111-1307, USA.  */


#ifndef IAPWS_IF97_LOCAL_H
#define IAPWS_IF97_LOCAL_H


/* Specific gas constant of water.  */
#define R IF97_R

/* Molar gas constant.  */
#define RM IF97_RM

/* Molar mass of water.  */
#define MM IF97_MM

/* Critical temperature of water. */
#define TC IF97_TC

/* Critical pressure of water. */
#define PC IF97_PC

/* Critical density of water. */
#define RHOC IF97_RHOC

/* Triple-point temperature of water. */
#define TT IF97_TT

/* Triple-point pressure of water. */
#define PT IF97_PT

/* Boiling-point temperature of water. */
#define TB IF97_TB

/* Zero-point temperature of the degree Centigrade temperature scale.  */
#define T0 273.15

/* Saturation pressure of water at 273.15 K.  */
#define P0 611.213


#endif /* not IAPWS_IF97_LOCAL_H */
