/* ref.c --- reference constants.

   Copyright (C) 2001, 2002 Ralph Schleicher

   Author: Ralph Schleicher <rs@nunatak.allgaeu.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
   Boston, MA 02111-1307, USA.  */


#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <c-stand.h>

#include "if97.h"


/* Return the specific gas constant of water.  */
double
if97_r (void)
{
  return IF97_R;
}


/* Return the molar gas constant.  */
double
if97_r_m (void)
{
  return IF97_RM;
}


/* Return the molar mass of water.  */
double
if97_m_m (void)
{
  return IF97_MM;
}


/* Return the critical temperature of water.  */
double
if97_t_c (void)
{
  return IF97_TC;
}


/* Return the critical pressure of water.  */
double
if97_p_c (void)
{
  return IF97_PC;
}


/* Return the critical density of water.  */
double
if97_rho_c (void)
{
  return IF97_RHOC;
}


/* Return the triple-point temperature of water.  */
double
if97_t_t (void)
{
  return IF97_TT;
}


/* Return the triple-point pressure of water.  */
double
if97_p_t (void)
{
  return IF97_PT;
}


/* Return the boiling-point temperature of water at 101325 Pa.  */
double
if97_t_b (void)
{
  return IF97_TB;
}
