/* s2.c --- equations for region 2 (entropy interface).

   Copyright (C) 2001, 2002 Ralph Schleicher

   Author: Ralph Schleicher <rs@nunatak.allgaeu.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
   Boston, MA 02111-1307, USA.  */


#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <c-stand.h>

#include "if97.h"
#include "if97i.h"


/* Return the temperature of water at pressure P and entropy S.  */
double
if97i_s2_t (double p, double s)
{
  return ((p <= 4.0E+6) ?
	  if97i_s2a_t (p, s) :
	  ((s >= 5.85E+3) ?
	   if97i_s2b_t (p, s) : if97i_s2c_t (p, s)));
}
