;;; symbols.lisp --- symbols.

;; Copyright (C) 2012 Ralph Schleicher

;; Redistribution and use in source and binary forms, with or without
;; modification, are permitted provided that the following conditions
;; are met:
;;
;;    * Redistributions of source code must retain the above copyright
;;      notice, this list of conditions and the following disclaimer.
;;
;;    * Redistributions in binary form must reproduce the above copyright
;;      notice, this list of conditions and the following disclaimer in
;;      the documentation and/or other materials provided with the
;;      distribution.
;;
;;    * The name of the author may not be used to endorse or promote
;;      products derived from this software without specific prior
;;      written permission.
;;
;; THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS
;; OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
;; WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
;; ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
;; INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
;; (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
;; SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
;; HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
;; STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
;; IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
;; POSSIBILITY OF SUCH DAMAGE.

;;; Code:

(in-package :rs-lisp)

(export 'symbol-name*)
(defun symbol-name* (symbol)
  "Return the name of SYMBOL including the package prefix.

If SYMBOL does not belong to a package, just return it's name.
If SYMBOL is a keyword, add a leading colon character to the name.
If SYMBOL is an external symbol of a package, seperate the package
name and the symbol name by a colon character.  Otherwise, seperate
the package name and the symbol name by two colon characters."
  (let ((name (symbol-name symbol))
	(package (symbol-package symbol)))
    (cond ((null package)
	   name)
	  ((eql package (find-package :keyword))
	   (concatenate 'string ":" name))
	  (t
	   (concatenate 'string
			(package-name package)
			(multiple-value-bind (sym stat)
			    (find-symbol name package)
			  (if (eql stat :external) ":" "::"))
			name)))))

;;; symbols.lisp ends here
